/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: SCF applet card service sample.
 *
 */

package scfbundle;

import jp.co.ricoh.dsdk.scard.framework.card.Card;
import jp.co.ricoh.dsdk.scard.framework.card.CardAccessException;
import jp.co.ricoh.dsdk.scard.framework.service.CardServiceException;
import jp.co.ricoh.dsdk.scard.framework.service.UnsupportedCardException;
import jp.co.ricoh.dsdk.scard.framework.util.APDUException;
import jp.co.ricoh.dsdk.scard.framework.util.RequestAPDU;
import jp.co.ricoh.dsdk.scard.framework.util.ResponseAPDU;
import jp.co.ricoh.dsdk.scard.option.applet.AppletService;
import jp.co.ricoh.dsdk.scard.option.applet.AppletServiceImpl;

/**
 * MyAppletService class
 * This class implements AppletService and extends AppletServiceImpl.
 * 
 * MyAppletServiceクラス
 * AppletServiceの実装で、AppletServiceImplを継承します。
 */
public class MyAppletService extends AppletServiceImpl implements AppletService {
	
	/**
	 * Command bytes to be used to know if the card is supported by this CardService.
	 * 
	 * このカードサービスがサポートするカードかを判別するためにカードに送信するコマンド。
	 */
	private static final byte[] GETDATA_CPLC = new byte[] {
		(byte)0x80,(byte)0xCA,(byte)0x9F,(byte)0x7F,(byte)0x2D
	};
	
	/**
	 * Expected response code of a supported card.
	 * 
	 * サポート対象のカードであった場合に期待されるレスポンスコード。
	 */
	private static final byte SW1_OK = (byte)0x90;
	
	/* (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.scard.framework.service.CardService#initialize(jp.co.ricoh.dsdk.scard.framework.card.Card)
	 */
	public synchronized void initialize(Card card) throws UnsupportedCardException, CardServiceException {
		super.initialize(card);
		
		boolean supported = false;
		
		RequestAPDU request = new RequestAPDU(GETDATA_CPLC);
		ResponseAPDU response = null;
		try {
			response = card.getIO().transmit(request);
			
			if (response.sw1() == SW1_OK) supported = true;
		
		} catch (CardAccessException e) {
			throw new CardServiceException(e);
		} catch (APDUException e) {
		}
		
		if (!supported) {
			/*
			 * if the card is not supported by this CardService
			 * サポートしていないカードの場合
			 */
			throw new UnsupportedCardException();
		}
	}
}
